import discord
import spotify_challenge
from discord.ext import commands

TOKEN = "" # ここにDiscordのBotのTokenを入れる

intents = discord.Intents.default()
intents.message_content = True
bot = commands.Bot(command_prefix=">", intents=intents)

@bot.command()
async def search(ctx, keyword):
    if len(keyword) < 2:
        await ctx.send("2文字以上の検索キーワードを入力してね")
        return
    elif len(keyword) > 20:
        await ctx.send("検索キーワードは20文字以内にしてね")
        return

    result = spotify_challenge.search_artist(keyword)

    # 検索結果がない場合の対応
    if not result:
        await ctx.send("検索結果が0件だったよ。キーワードを調整してみてね")
        return

    # アーティスト情報を取得して出力
    name = result["name"]
    url = result["external_urls"]["spotify"]
    await ctx.send(f"アーティスト名: {name}\nURL: {url}")
    
bot.run(TOKEN)
