import discord
import spotify_try
from discord.ext import commands

TOKEN = "" # ここにDiscordのBotのTokenを入れる

intents = discord.Intents.default()
intents.message_content = True
bot = commands.Bot(command_prefix=">", intents=intents)

@bot.command()
async def search(ctx, keyword):
    if len(keyword) < 2:
        await ctx.send("2文字以上の検索キーワードを入力してね")
        return
    elif len(keyword) > 20:
        await ctx.send("検索キーワードは20文字以内にしてね")
        return

    result = spotify_try.search_artist(keyword)

    if len(result["artists"]["items"]) == 0:
        await ctx.send("検索結果が0件だったよ。キーワードを調整してみてね")
    elif len(result["artists"]["items"]) == 1:
        url = result["artists"]["items"][0]["external_urls"]["spotify"]
        await ctx.send(url)
    elif len(result["artists"]["items"]) > 1:
        url = result["artists"]["items"][0]["external_urls"]["spotify"]
        message = f"複数見つかったけど、これ？ {url}"
        await ctx.send(message)

@bot.command()
async def search_track(ctx, keyword):
    if len(keyword) < 2:
        await ctx.send("2文字以上の検索キーワードを入力してね")
        return
    elif len(keyword) > 20:
        await ctx.send("検索キーワードは20文字以内にしてね")
        return

    result = spotify_try.search_track(keyword)

    if len(result["tracks"]["items"]) == 0:
        await ctx.send("検索結果が0件だったよ。キーワードを調整してみてね")
    elif len(result["tracks"]["items"]) == 1:
        url = result["tracks"]["items"][0]["external_urls"]["spotify"]
        await ctx.send(url)
    elif len(result["tracks"]["items"]) > 1:
        url = result["tracks"]["items"][0]["external_urls"]["spotify"]
        message = f"複数見つかったけど、これ？ {url}"
        await ctx.send(message)

bot.run(TOKEN)