import requests

client_id = ""  # Spotifyに登録したアプリケーションのクライアントIDを設定します。
client_secret = ""  # Spotifyに登録したアプリケーションのクライアントシークレットを設定します。


def search_artist(keyword):
    # 1. Spotifyで認証
    auth_response = requests.post(
        "https://accounts.spotify.com/api/token",
        data={
            "grant_type": "client_credentials",
            "client_id": client_id,
            "client_secret": client_secret,
        },
    )

    # 2. アクセストークン取り出し
    response_json = auth_response.json()
    token = response_json["access_token"]

    # 3. 指定されたキーワードでSpotifyを検索
    search_response = requests.get(
        "https://api.spotify.com/v1/search",
        headers={
            "Authorization": f"Bearer {token}",
            "Accept-Language": "ja"  # 日本語情報を指定
        },
        params={
            "q": keyword,
            "type": "artist",
            "market": "JP",
        },
    )

    # 4. 検索結果のアーティストIDを取得
    search_results = search_response.json()
    artist_id = search_results['artists']['items'][0]['id']

    # 5. アーティストの詳細情報を取得
    artist_response = requests.get(
        f"https://api.spotify.com/v1/artists/{artist_id}",
    headers={
            "Authorization": f"Bearer {token}",
            "Accept-Language": "ja"  # 日本語情報を指定
        },
    )

    return artist_response.json()
